library(scales)
library(lme4)

figureDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 3 - Oyster survival experiment/Figure components/'
csvDirectory = 'D:/Manuscripts/Chapter 5 - Fivash et al. 2021 Ecological Engineering/Figure 3 - Oyster survival experiment/CSV/'

setwd(csvDirectory)
d = read.csv('Oyster survival experiment Hellegat.csv')
d$Date = as.POSIXct(d$Date)
d$Location = factor(d$Location, levels = c('Mudflat Out','Mudflat In','Saltmarsh'))
levels(d$Location) = c('Mudflat','Protected mudflat','Saltmarsh')

index = 1:dim(d)[1]
d$Survival[index %% 10 == 0] = 20*d$Survival[index %% 10 == 0]/17
d$Death[index %% 10 == 0] = 20*d$Death[index %% 10 == 0]/17
d$Missing[index %% 10 == 0] = 20*d$Missing[index %% 10 == 0]/17

d$Survival = d$Survival/20
d$Death = d$Death/20
d$Missing = d$Missing/20

survival = as.numeric(tapply(d$Survival, list(d$Location, d$Day), mean))
day = rep(sort(unique(d$Day)), each = 3)
location = rep(1:3, times = length(unique(d$Day)))
col = alpha(colorRampPalette(c('black','grey'))(3), 0.8)
pch = 21:23

tiff('Figure 3a.tiff', width = 20, height = 20, units = "cm", res = 300)
par(mar = c(5,5,4,4))
plot(survival ~ day, cex = 1.5, cex.lab= 1.4, cex.axis = 1.4,
     pch = pch[location], log = '',
     bg = col[location], bty = 'n',
     ylab = 'Oyster survival (proportion)',
     xlab = 'Days since installation')
     #col = alpha('white',0))
points(d$Survival ~ d$Day, 
     pch = '.', cex = 5,
     col = col[d$Location])
 
y = d$Survival
x = d$Day
z = d$Location

m1 = lm(log(y[y != 0]) ~ x[y != 0] * z[y != 0])
m2 = lm(log(y[y != 0]) ~ x[y != 0] * z[y != 0] - z[y != 0])
m3 = lm(log(y[y != 0]) ~ x[y != 0] * z[y != 0] - z[y != 0] + 0)
AIC(m1,m2,m3)
summary(m1)
summary(m2)
summary(m3)
a = summary(m2)$coefficients[1]
b = summary(m2)$coefficients[2]
c1 = summary(m2)$coefficients[3]
c2 = summary(m2)$coefficients[4]
xv = seq(min(d$Day), max(d$Day), length.out = 1000)
yv0 = exp(a + b*xv)
yv1 = exp(a + (b + c1)*xv)
yv2 = exp(a + (b + c2)*xv)
lines(yv0 ~ xv, lwd = 2, col = col[1])
lines(yv1 ~ xv, lwd = 2, col = col[2])
lines(yv2 ~ xv, lwd = 2, col = col[3])

points(c(0.95,0.90,0.85) ~ c(103,103,103), pch = c(23,22,21), bg = rev(col), cex = 2)
legend(y = 1, x = 100, bty = 'n', legend = c('Saltmarsh','Protected mudflat','Mudflat'), cex = 1.4)
setwd(figureDirectory)
dev.off()

# --------- Source of mortality plot

setwd(csvDirectory)
d = read.csv('Oyster survival experiment Hellegat.csv')
d$Date = as.POSIXct(d$Date)
d$Location = factor(d$Location, levels = c('Mudflat Out','Mudflat In','Saltmarsh'))
levels(d$Location) = c('Mudflat','Protected mudflat','Saltmarsh')
d = d[d$Day == 160,]

n = rep(NA, times = 3)
filter = d$Location == 'Mudflat'
n[1] = sum(c(d$Survival[filter],d$Missing[filter],d$Death[filter]))
filter = d$Location == 'Protected mudflat'
n[2] = sum(c(d$Survival[filter],d$Missing[filter],d$Death[filter]))
filter = d$Location == 'Saltmarsh'
n[3] = sum(c(d$Survival[filter],d$Missing[filter],d$Death[filter]))
survival.prop = c(sum(d$Survival[d$Location == 'Mudflat']),
      sum(d$Survival[d$Location == 'Protected mudflat']),
      sum(d$Survival[d$Location == 'Saltmarsh']))
missing.prop = c(sum(d$Missing[d$Location == 'Mudflat']),
                 sum(d$Missing[d$Location == 'Protected mudflat']),
                 sum(d$Missing[d$Location == 'Saltmarsh']))
death.prop = c(sum(d$Death[d$Location == 'Mudflat']),
                 sum(d$Death[d$Location == 'Protected mudflat']),
                 sum(d$Death[d$Location == 'Saltmarsh']))
prop.test(x = survival.prop,
          n = n)
prop.test(x = missing.prop,
          n = n)
prop.test(x = death.prop[2:3],
          n = (n[2:3] - missing.prop[2:3]))
prop.test(x = death.prop[2:3],
          n = (n[2:3]))
tiff('Figure 3b.tiff', width = 20, height = 20, units = "cm", res = 300)
par(mar = c(5,5,4,4))
plot(c(), ylim = c(0,1), xlim = c(0,4), bty = 'n', xaxt = 'n',
     ylab = 'Oyster fate after 160 days (proportion)', xlab = '', cex.lab= 1.4, cex.axis = 1.4)
# axis(side = 1, at = c(0.5,1.5,2.5), labels = c('Mudflat','Protected', 'Saltmarsh'), tick = F, cex.axis = 1.4)
axis(side = 1, at = c(0.5,2.5), labels = c('Mudflat', 'Saltmarsh'), tick = F, cex.axis = 1.4)
axis(side = 1, at = 1.5, line = -0.5, labels = 'Protected', tick = F, cex.axis = 1.4)
axis(side = 1, at = 1.5, line = 0.8, labels = 'mudflat', tick = F, cex.axis = 1.4)
rect(xleft = c(0,1.05,2.1), xright = c(0.9,1.95,3), ybottom = c(0,0,0), ytop = survival.prop/n, density = 0)
rect(xleft = c(0,1.05,2.1), xright = c(0.9,1.95,3), ybottom = survival.prop/n, ytop = (survival.prop + death.prop)/n, density = 5)
rect(xleft = c(0,1.05,2.1), xright = c(0.9,1.95,3), ybottom = (survival.prop + death.prop)/n, ytop = c(1,1,1), density = 30)
legend(y = 1, x = 3.05, bty = 'n', density = c(0,20,50), legend = c('Survivors','Dead','Missing'), cex= 1.4)
setwd(figureDirectory)
dev.off()
# ---------------------
# Mixed model for Rev #2
Survival = c()
Missing = c()
Phys.dead = c()
Location = c()
Plot.ID = c()
for(i_plot in 1:dim(d)[1]){
   n = d$Missing[i_plot] + d$Death[i_plot] + d$Survival[i_plot]
   survival = c(rep(0, times = n - d$Survival[i_plot]),rep(1, times = d$Survival[i_plot]))
   missing = c(rep(1, times = d$Missing[i_plot]), rep(0, times = n - d$Missing[i_plot]))
   phys.dead = c(rep(NA, times = d$Missing[i_plot]), rep(1, times = d$Death[i_plot]), rep(0, times = d$Survival[i_plot]))
   location = rep(d$Location[i_plot], times = n)
   plot.ID = rep(d$Plot.ID[i_plot], times = n)
   
   Survival = c(Survival, survival)
   Missing = c(Missing, missing)
   Phys.dead = c(Phys.dead, phys.dead)
   Location = c(Location, location)
   Plot.ID = c(Plot.ID,plot.ID)
}

d2 = data.frame(Survival, Missing, Phys.dead, Location, Plot.ID)

m2 = glmer(Survival ~ Location + (1|Plot.ID),binomial, data = d2)
summary(m2)
#(beta=3.0, SE=0.84, z(197)=3.6, p=0.0003)

m2 = glmer(Missing ~ Location + (1|Plot.ID),binomial, data = d2)
summary(m2)
#(beta=-2.9, SE=0.6, z(197)=-5.0, p<0.0001)

m2 = glmer(Phys.dead ~ Location + (1|Plot.ID),binomial, data = d2)
summary(m2)
#(beta=-1.5, SE=0.6, z(78)=-2.7, p=0.007)
